package ch.sahits.game.openpatrician.model.map.impl;

import ch.sahits.game.openpatrician.model.map.ITradeRoute;
import ch.sahits.game.openpatrician.model.map.ITradeRouteStop;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.annotation.SetType;
import lombok.Getter;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Implementation of the {@link ITradeRoute}.
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class TradeRoute implements ITradeRoute {
    @Getter
    @SetType(ITradeRouteStop.class)
    private Set<ITradeRouteStop> tradeStops = new LinkedHashSet<>();

    /**
     * Add a new trade stop to the route.
     * @param tradeStop to be added
     */
    public void addTradeStop(ITradeRouteStop tradeStop) {
        this.tradeStops.add(tradeStop);
    }
}
