package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Captain properties.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 21, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "captain")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class CaptainProperties {
    private int max;
    private int timeInTown;
    private int maxPresence;
}
