package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;


interface IBasePatrol extends ISideRoomPerson {

	/**
	 * Get the name of the client.
	 * @return name of the person
	 */
	String getName();

	/**
	 * Set the name of the client.
	 * @param name of the client
	 */
	void setName(String name);
	/**
	 * Retrieve the destinations
	 * @return array of destination cities.
	 */
	ICity[] getDestinations();

	/**
	 * Set the destination city of the patrol.
	 * @param cities array of destination cities.
     */
	void setDestinations(ICity[] cities);
	/**
	 * Retrieve the premium for successful finishing the patrol.
	 * @return premium for completing the patrol
	 */
	int getPremium();

	/**
	 * Set the premium for task completion.
	 * @param premium for completing the patrol
     */
	void setPremium(int premium);

	/**
	 * Set the current index in the destination list.
	 * @param index current index of the destination
     */
	void setCurrentDestIndex(int index);

	/**
	 * Retrieve the current index in the destination list.
	 * @return current index of the destination.
     */
	int getCurrentDestIndex();

}