package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;

import java.time.LocalDateTime;

/**
 * A buyer promises to buy wares within a given time frame at a certain price.
 * The bought wares will not be sold to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IBuyer extends ISideRoomPerson {
	/**
	 * Retrieve the buyers name.
	 * @return name of the buyer
	 */
	String getName();
	/**
	 * Date until which the wares have to be delivered.
	 * @return deadline until when the wares need to be delivered.
	 */
	LocalDateTime getTimeFrame();
	/**
	 * Wares that are to be delivered.
	 * @return ware to be delivered
	 */
	IWare getWare();
	/**
	 * Retrieve the amount and price of the ware.
	 * @return amount and price for the ware.
	 */
	AmountablePrice<IWare> getAmountablePrice();

	/**
	 * Set the name of the buyer.
	 * @param name of the buyer
	 */
	void setName(String name);

	/**
	 * Set the deadline untill when the wares must be supplied.
	 * @param deadline date until when the wares must be ready
	 */
	void setDeadline(LocalDateTime deadline);

	/**
	 * Set the ware to be supplied.
	 * @param ware to be supplied.
	 */
	void setWare(IWare ware);

	/**
	 * Define the amount and price for the ware.
	 * @param amountablePrice amount and price of the ware
	 */
	void setAmountablePrice(AmountablePrice<IWare> amountablePrice);
}
