package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;
import javafx.beans.property.BooleanProperty;

import java.time.LocalDateTime;

/**
 * Interface describing a person in the tavern, who is only part time present
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
public interface ITavernPerson extends IPerson {

	/**
	 * Person leaves the tavern.
	 */
	void leave();

	/**
	 * Person arrives in the tavern.
	 */
	void arrive();
	/**
	 * Compute the days of absence since the last arrival,
	 * if the person is not present.
	 * @return number of days the person is in the tavern
	 */
	int getNumberOfDaysSinceArrival();

	/**
	 * Flag indicating if the person is present in the tavern.
	 * @return true if the person is present.
	 */
	boolean isPresent();

    /**
     * Property defining the presence/absence state.
     * @return boolean proerty indicating the presence in the tavern.
     */
    BooleanProperty isPresentProperty();

	/**
	 * Maximum number of days not present in the tavern.
	 * @return max number of absent days.
	 */
	int getMaxDaysAbsent();

	/**
	 * Retrieve the max number of days present in the tavern.
	 * @return max number of present days in the tavern
	 */
	int getMaxDaysPresent();

	/**
	 * Set the arrival date in the tavern
	 * @return date when the person becomes present.
	 */
	LocalDateTime getArrivalDate();
	/**
	 * Set the city of the tavern in which the person is located.
	 * @param city in which the tavern is located.
	 */
	void setCity(ICity city);

}
