package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Properties for Tavern.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 21, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "tavern")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class TavernProperties {

    private int beggarSailorRation;
    private Person person = new Person();

    @Getter
    @Setter
    public static class Person {
         private int maxAbsence;
         private int maxPresence;
    }
}
