package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Weapon properties
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 22, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "weapon")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class WeaponProperties {

    private Weapon cutlass = new Weapon();
    private Weapon sword = new Weapon();
    private Weapon bow = new Weapon();
    private Weapon crossbow = new Weapon();
    private Weapon musket = new Weapon();
    private Weapon trebuchetSmall = new Weapon();
    private Weapon trebuchetBig = new Weapon();
    private Weapon ballistaSmall = new Weapon();
    private Weapon ballistaBig = new Weapon();
    private Weapon bombard = new Weapon();
    private Weapon canon = new Weapon();

    @Getter
    @Setter
    public static class Weapon {
        private double minExperiance;
        private int duration;
    }
}
