package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.AUpdatable;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of a pirate. Every city can have a pirate and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatable
public class TavernPirateState extends BaseTavernPerson implements IPirate {
    @Getter
	@Setter
	private int followers;
    @Getter
	@Setter
	private String name;
    @Getter
	@Setter
    private String lastName;
    @Getter
	@Setter
	private double profitShare;
}
