package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.AUpdatableCityRelated;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.Setter;

/**
 * Implementation of a transport trader. Every city can have a transport trader and is referenced
 * through it's TavernEngine.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 20, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@AUpdatableCityRelated
public class TransportTraderState extends BaseTavernPerson implements
ITransportTrader {
    @Getter
    @Setter
    private String name;
    @Getter
    @Setter
    private ICity destination;
    @Getter
    @Setter
	private int premium;
    @Getter
    @Setter
    private int neededCapacity;

}
