package ch.sahits.game.openpatrician.model.personal;

import ch.sahits.game.openpatrician.model.city.ICity;

import java.time.LocalDateTime;


/**
 * Defining the personal data of a person.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
public interface IPersonalData {
	/**
	 * Retrieve the players name
	 * @return first name
	 */
	String getName();
	/**
	 * Get a players last name
	 * @return last name
	 */
	String getLastName();
	/**
	 * Check if the player is male
	 * @return flag if the person is male
	 */
	boolean isMale();
	/**
	 * Retrieve the birth place
	 * @return birth city
	 */
	ICity getBirthPlace();
	/**
	 * Retrieve the birth date
	 * @return birth date
	 */
	LocalDateTime getBirthDate();

	/**
	 * Compute the current age
	 * @param current date
	 * @return age in years per <code>current</code>
	 */
	int getAge(LocalDateTime current);

}
