package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

/**
 * Implementation of the reputation.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 23, 2012
 *
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Reputation implements IReputation {

	private int reputationLastWeek = 0;
	private int reputationCurrentWeek = 0;

	private final ICity city;
	private final IPlayer player;

	public Reputation(ICity city, IPlayer player) {
		super();
		this.city = city;
		this.player = player;
	}


	@Override
	public int getReputationDifference() {
		return reputationCurrentWeek-reputationLastWeek;
	}

	public void addWareReputation(int wareReputation) {
		reputationLastWeek=reputationCurrentWeek;
		reputationCurrentWeek+=wareReputation;
	}

	@Override
	public int getPopularity() {
		return reputationCurrentWeek;
	}


    @Override
    public void update(int amount) {
        reputationCurrentWeek += amount;
    }
}
