package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import java.time.LocalDateTime;

@Getter
@EqualsAndHashCode
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class SpouseData extends PersonalData implements ISpouseData {

	private final int popularityInHerHomeTown;
	private final int popularityInYourHomeTown;
	private final int connectionsInHerHomeTown;
	private final int connectionsInYourHomeTown;
	private final String portraitResourceName;

    @Builder
    public SpouseData(String name, String lastName, boolean male,
                      ICity birthplace, LocalDateTime birthDate, int popHer, int popYour,
                      int conHer, int conYour, String portraitResourceName) {
        super(name, lastName, male, birthplace, birthDate);
        this.popularityInHerHomeTown = popHer;
        this.popularityInYourHomeTown = popYour;
        this.connectionsInHerHomeTown = conHer;
        this.connectionsInYourHomeTown = conYour;
        this.portraitResourceName = portraitResourceName;
    }

}
