package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Strategy for decing how to react on events.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 18, 2016
 */
public interface IAIEventDecisionStrategy {
    /**
     * Decide if the offer of a marriage broker should be accepted.
     * @param player who has to make the decision
     * @return true if the player accepts the marriage broker offer
     */
    boolean acceptMarriagBrokereOffer(IAIPlayer player);
    /**
     * Decide if a marriage offer should be accepted.
     * @param player who has to make the decision
     * @return true if hte player accepts the marriage offer
     */
    boolean acceptMarriageOffer(IAIPlayer player);

    /**
     * Decide if a celebration should be executed.
     * @param player who has to make the decision
     * @param city where the celebration takes place
     * @return true if the player whished to order a celebration in city.
     */
    boolean shouldOrderCelebration(IAIPlayer player, ICity city);
}
