package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

import java.util.Optional;

/**
 * Strategy to decide and join a guild.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 15, 2016
 */
public interface IAIGuildJoinStrategy {
    /**
     * Decide if <code>player</code> should join the guild in the <code>city</code>.
     * It may be that the player has a <code>vessel</code> in the city.<br>
     * If the player is already a member of the guild false is returned always.
     * @param player who should decide on joining
     * @param city where to join
     * @param vessel possible vessel in the city
     * @return true if the player should join the  guild.
     */
    boolean shouldJoin(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel);

    /**
     * Join the guild in the city.
     * @param player who should decide on joining
     * @param city where to join
     */
    void join(IAIPlayer player, ICity city);
}
