package ch.sahits.game.openpatrician.model.player;

import java.util.HashSet;
import java.util.Set;

/**
 * The trade strategy type defines a type of strategy
 * that is used by the AIEngine to determine the next step in
 * the trading for an AI player.
 */
public interface IAITradeStrategyType extends BaseStrategyType<IAITradeStrategy> {

    /**
     * Get a set of preference that indicate good matches for this strategy. The set is empty
     * by default.
     * @return empty set.
     */
    default Set<ETradeStrategyPreference> getStrategyPreferrance() {
        return new HashSet<>();
    }
}
