package ch.sahits.game.openpatrician.model.ui;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * This is a wrapper object for a dialog state to be sent through the
 * even bus.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 09, 2016
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class TargetedDialogStateWrapper implements IEventMetaDataProvider {
    private final IPlayer player;
    private final IDialogState state;
    private String className;
    private String methodName;

    public TargetedDialogStateWrapper(IPlayer player, IDialogState state) {
        this.player = player;
        this.state = state;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
