/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.event.data.ResumeGame;
import ch.sahits.game.openpatrician.model.event.SchedulableTask;
import com.google.common.eventbus.AsyncEventBus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class PausableSchedulableTask
extends SchedulableTask {
    private boolean paused = false;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;

    @PostConstruct
    protected void register() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    public void pause(PauseGame evt) {
        this.paused = true;
    }

    public void resume(ResumeGame evt) {
        this.paused = false;
    }

    @Override
    public void run() {
        if (!this.paused) {
            super.run();
        }
    }
}

