/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.javafx.IJavaFXApplicationThreadExecution;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public final class Company
implements ICompany {
    private static final Logger log = LoggerFactory.getLogger(Company.class);
    private IPlayer owner = null;
    private ICity homeTown;
    private long companyValue;
    private LongProperty cash;
    @Autowired
    @XStreamOmitField
    private IJavaFXApplicationThreadExecution threadExecutor;

    public Company(ICity homeTown, long cash, long random) {
        this.homeTown = homeTown;
        this.cash = new SimpleLongProperty((Object)this, "cash", cash);
    }

    public void setOwner(IPlayer player) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkArgument((this.owner == null ? 1 : 0) != 0, (Object)"The owner may only be set once");
        this.owner = player;
    }

    @Override
    public long getCash() {
        return this.cash.get();
    }

    @Override
    public void updateCash(long diff) {
        this.threadExecutor.execute(() -> this.updateCashDirectly(diff));
    }

    @Override
    public void updateCashDirectly(long diff) {
        long oldValue = this.cash.get();
        this.cash.set(oldValue + diff);
        if (this.cash.get() < 0L && diff < 0L) {
            log.warn("Company of {} {} (uuid {}) cash dropped below 0: {}", new Object[]{this.owner.getName(), this.owner.getLastName(), this.owner.getUuid(), this.cash.get()});
        }
    }

    @Override
    public LongProperty cashProperty() {
        return this.cash;
    }

    @Override
    public ICity getHomeTown() {
        return this.homeTown;
    }

    @Override
    public long getCompanyValue() {
        return this.companyValue;
    }

    @Override
    public void setCompanyValue(long companyValue) {
        this.companyValue = companyValue;
    }
}

