/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IBaseTraveler;
import ch.sahits.game.openpatrician.model.people.impl.BaseTavernPerson;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

abstract class BaseTravelerState
extends BaseTavernPerson
implements IBaseTraveler {
    private ICity destination;
    private int premium;
    private LocalDateTime arrivalAtDestinationDate;

    BaseTravelerState() {
    }

    @Override
    public int getMaxDaysPresent() {
        int maxDays = super.getMaxDaysPresent();
        if (this.getArrivalAtDestinationDate() != null) {
            long deltaDays = ChronoUnit.DAYS.between(this.date.getCurrentDate(), this.getArrivalAtDestinationDate());
            if (deltaDays <= 0L) {
                return 0;
            }
            return Math.min(maxDays, (int)deltaDays);
        }
        return maxDays;
    }

    @Override
    public ICity getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(ICity destination) {
        this.destination = destination;
    }

    @Override
    public int getPremium() {
        return this.premium;
    }

    @Override
    public void setPremium(int premium) {
        this.premium = premium;
    }

    public LocalDateTime getArrivalAtDestinationDate() {
        return this.arrivalAtDestinationDate;
    }

    @Override
    public void setArrivalAtDestinationDate(LocalDateTime arrivalAtDestinationDate) {
        this.arrivalAtDestinationDate = arrivalAtDestinationDate;
    }
}

