/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.sea.ITravellingVessels;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Point2D;
import javafx.scene.shape.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class TravellingVessels
implements ITravellingVessels {
    private static final Logger log = LoggerFactory.getLogger(TravellingVessels.class);
    @MapType(key=INavigableVessel.class, value=TravellingVessel.class)
    private final Map<INavigableVessel, TravellingVessel> vessels = new ConcurrentHashMap<INavigableVessel, TravellingVessel>();
    @Autowired
    private IMap map;

    public void addVessel(INavigableVessel vessel, Optional<Path> path, List<Point2D> points) {
        Point2D destination = points.get(points.size() - 1);
        Optional<ICity> destCity = this.findCity(destination);
        if (vessel instanceof IShip) {
            this.setTravelDestionation((IShip)vessel, destCity);
        } else if (vessel instanceof IGroupableVessel) {
            for (IShip ship : ((IGroupableVessel)vessel).getShips()) {
                this.setTravelDestionation(ship, destCity);
            }
        }
        TravellingVessel tv = new TravellingVessel(vessel);
        tv.setCalculatablePath(points);
        path.ifPresent(tv::setDrwawablePath);
        this.vessels.put(vessel, tv);
        log.debug("Add vessel {} ({}) to travelling vessels.", (Object)vessel.getName(), (Object)vessel.getUuid());
    }

    private void setTravelDestionation(IShip vessel, Optional<ICity> destCity) {
        if (destCity.isPresent()) {
            vessel.setTravelState(EShipTravelState.TRAVEL_TO_CITY);
        } else {
            vessel.setTravelState(EShipTravelState.TRAVEL_TO_DESTINATION);
        }
    }

    public void remove(INavigableVessel vessel) {
        this.vessels.remove(vessel);
        log.debug("Remove vessel {} ({}) frome travelling vessels.", (Object)vessel.getName(), (Object)vessel.getUuid());
    }

    @Override
    public Iterator<INavigableVessel> iterator() {
        return this.vessels.keySet().iterator();
    }

    @Override
    public TravellingVessel getTravellingVessel(INavigableVessel vessel) {
        return this.vessels.get(vessel);
    }

    @Override
    public boolean isTravelling(INavigableVessel vessel) {
        return this.vessels.containsKey(vessel);
    }

    public Optional<ICity> findCity(Point2D location) {
        for (ICity city : this.map.getCities()) {
            if (!city.getCoordinates().equals((Object)location)) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }
}

