/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.model.city.impl.Contribution;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@ClassCategory(value={EClassCategory.STARTUP})
public class ContributionConverter
implements Converter {
    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Contribution contribution = (Contribution)o;
        hierarchicalStreamWriter.addAttribute("ware", contribution.getWare().name());
        hierarchicalStreamWriter.addAttribute("timestamp", contribution.getTimestamp().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        hierarchicalStreamWriter.addAttribute("amount", String.valueOf(contribution.getAmount()));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        EWare ware = EWare.valueOf(hierarchicalStreamReader.getAttribute("ware"));
        LocalDateTime timestamp = LocalDateTime.parse(hierarchicalStreamReader.getAttribute("timestamp"));
        int amount = Integer.parseInt(hierarchicalStreamReader.getAttribute("amount"));
        return new Contribution(timestamp, amount, ware);
    }

    public boolean canConvert(Class aClass) {
        return Contribution.class.equals((Object)aClass);
    }
}

