/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.plugin.installer;

import ch.sahits.game.openpatrician.utilities.LocalStorage;
import ch.sahits.game.openpatrician.utilities.plugin.BasePluginDefinition;
import ch.sahits.game.openpatrician.utilities.plugin.EPluginType;
import ch.sahits.game.openpatrician.utilities.plugin.PluginConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PluginDirectoryService {
    private static final Logger log = LoggerFactory.getLogger(PluginDirectoryService.class);
    private LocalStorage localStorage;

    public PluginDirectoryService(LocalStorage localStorage) {
        this.localStorage = localStorage;
    }

    public void createPluginDir() {
        for (EPluginType pluginType : EPluginType.values()) {
            this.localStorage.getPluginTypeDirecotryPath(pluginType);
        }
    }

    public void installExtractedPlugin(String tempPluginFolder) throws JAXBException, IOException {
        String outputdirectory = this.localStorage.getPluginTypeDirecotryPath(this.getPluginType(tempPluginFolder));
        File tempDir = new File(tempPluginFolder);
        File[] jars = tempDir.listFiles((file, name) -> name.endsWith(".jar"));
        String pluginJarName = jars[0].getName();
        File pluginDirectory = new File(outputdirectory);
        File src = new File(tempDir, pluginJarName);
        File dest = new File(outputdirectory, pluginJarName);
        if (pluginDirectory.list((file, name) -> name.equals(pluginJarName)).length > 0) {
            log.info("Should delete old plugin");
            FileUtils.forceDelete((File)dest);
        }
        FileUtils.copyFile((File)src, (File)dest);
    }

    public void updatePluginProperties(List<String> basePackages) throws IOException {
        File f = new File(this.localStorage.getPluginDirectory(), "plugin.properties");
        if (!f.exists()) {
            f.createNewFile();
        }
        Properties pluginProperties = new Properties();
        pluginProperties.load(new FileInputStream(f));
        Object basePackageValue = pluginProperties.getProperty("plugin.basepackages");
        if (basePackageValue != null) {
            String[] definedPackages = ((String)basePackageValue).split(",");
            for (String definedPackage : definedPackages) {
                basePackages.remove(definedPackage);
            }
            for (String basePackage : basePackages) {
                basePackageValue = (String)basePackageValue + "," + basePackage;
            }
            pluginProperties.setProperty("plugin.basepackages", (String)basePackageValue);
        } else {
            Object value = "";
            for (String basePackage : basePackages) {
                value = (String)value + basePackage + ",";
            }
            value = ((String)value).substring(0, ((String)value).lastIndexOf(","));
            pluginProperties.setProperty("plugin.basepackages", (String)value);
        }
        pluginProperties.store(new FileOutputStream(f), "Plugin properties");
    }

    private EPluginType getPluginType(String tempDirPath) throws JAXBException {
        File pluginfile = new File(tempDirPath, "plugin.xml");
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        Unmarshaller um = pluginConfiguration.jaxbPluginUnMarshaller();
        BasePluginDefinition plugin = (BasePluginDefinition)um.unmarshal(pluginfile);
        return plugin.getType();
    }
}

