/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.plugin.installer;

import ch.sahits.game.openpatrician.plugin.installer.PluginDirectoryService;
import ch.sahits.game.openpatrician.plugin.installer.ReflectionProvider;
import ch.sahits.game.openpatrician.plugin.installer.UnzipUtility;
import ch.sahits.game.openpatrician.utilities.LocalStorage;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class PluginInstaller
extends Application {
    private static final Logger log = LoggerFactory.getLogger(PluginInstaller.class);
    private PluginDirectoryService directoryService;
    private UnzipUtility unzipUtility;
    private ReflectionProvider reflectionProvider;
    private ApplicationContext context;
    private Pane rootGroup;
    boolean displayErrors = true;

    public static void main(String[] args) {
        PluginInstaller.launch((String[])args);
    }

    public void init() {
        this.context = SpringApplication.run(PluginInstaller.class, (String[])new String[0]);
        this.directoryService = (PluginDirectoryService)this.context.getBean(PluginDirectoryService.class);
        this.directoryService.createPluginDir();
        this.unzipUtility = (UnzipUtility)this.context.getBean(UnzipUtility.class);
        this.reflectionProvider = new ReflectionProvider();
    }

    public void start(Stage stage) {
        stage.setTitle("OpenPatrician Plugin Installer");
        FileChooser fileChooser = new FileChooser();
        Button openButton = new Button("Select Plugin");
        openButton.setOnAction(e -> {
            File file = fileChooser.showOpenDialog((Window)stage);
            if (file != null) {
                this.openFile(file);
            }
        });
        this.rootGroup = new VBox(12.0);
        this.rootGroup.getChildren().addAll((Object[])new Node[]{openButton});
        this.rootGroup.setPadding(new Insets(12.0, 12.0, 12.0, 12.0));
        stage.setScene(new Scene((Parent)this.rootGroup, 300.0, 100.0));
        stage.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile(File file) {
        String tempDirPath = System.getProperty("java.io.tmpdir") + File.separatorChar + "plugin";
        try {
            log.info("Chosen plugin {}", (Object)file.getAbsolutePath());
            this.unzipUtility.unzip(file.getAbsolutePath(), tempDirPath);
            File tmpDir = new File(tempDirPath);
            File[] jarFiles = tmpDir.listFiles((dir, name) -> name.endsWith(".jar"));
            if (jarFiles.length > 0) {
                this.validateAndInstall(tempDirPath, jarFiles[0]);
            } else {
                log.info("There was no jar file in the plugin archive");
                if (this.displayErrors) {
                    Text text = this.createErrorText("There was no jar file in the plugin archive " + file.getAbsolutePath());
                    this.rootGroup.getChildren().add((Object)text);
                }
            }
        }
        catch (IOException e) {
            if (this.displayErrors) {
                Text text = this.createErrorText("Installation failed due to I/O error: " + e.getMessage());
                this.rootGroup.getChildren().add((Object)text);
            }
            log.error("Installation failed due to I/O error", (Throwable)e);
        }
        catch (JAXBException e) {
            if (this.displayErrors) {
                Text text = this.createErrorText("Failed to parse the plugin.xml");
                this.rootGroup.getChildren().add((Object)text);
            }
            log.error("Failed to parse the plugin.xml", (Throwable)e);
        }
        finally {
            File f = new File(tempDirPath);
            if (f.exists()) {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    if (this.displayErrors) {
                        Text text = this.createErrorText("Failed to delete temporary directory " + f.getAbsolutePath() + ". Please delete manually.");
                        this.rootGroup.getChildren().add((Object)text);
                    }
                    log.error("Failed to delete temporary directory", (Throwable)e);
                }
            }
        }
    }

    private Text createErrorText(String content) {
        Text text = new Text(content);
        text.wrappingWidthProperty().bind((ObservableValue)this.rootGroup.widthProperty());
        return text;
    }

    @VisibleForTesting
    void validateAndInstall(String tempDirPath, File jarFile) throws IOException, JAXBException {
        List basePackages = this.unzipUtility.getBasePackages(jarFile.getAbsolutePath());
        URL[] urls = new URL[]{jarFile.toURI().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        String[] packages = new String[basePackages.size()];
        for (int i = 0; i < packages.length; ++i) {
            packages[i] = (String)basePackages.get(i);
        }
        Reflections reflections = this.reflectionProvider.create(classLoader, packages);
        Set subTypes = reflections.getSubTypesOf(Object.class);
        boolean valid = this.validatePluginClasses(subTypes);
        if (valid) {
            this.directoryService.installExtractedPlugin(tempDirPath);
            this.directoryService.updatePluginProperties(basePackages);
        }
    }

    @VisibleForTesting
    boolean validatePluginClasses(Set<Class<?>> subTypes) {
        boolean valid = true;
        for (Class<?> subType : subTypes) {
            Method[] methods;
            if (Arrays.asList(subType.getInterfaces()).contains(InitializingBean.class)) {
                valid = false;
                log.info("Bean {} implements InitializingBean which is not allowed", (Object)subType.getName());
                if (this.displayErrors) {
                    Text text = this.createErrorText("Plugin is not valid as it contains classes implementing InitializingBean.");
                    this.rootGroup.getChildren().add((Object)text);
                }
            }
            for (Method method : methods = subType.getDeclaredMethods()) {
                if (method.getAnnotation(PostConstruct.class) == null) continue;
                valid = false;
                log.info("On {} the method {} is annotated with PostCostruct, which is not allowd.", (Object)subType.getName(), (Object)method.getName());
                if (!this.displayErrors) continue;
                Text text = this.createErrorText("Plugin is not valid as it contains classes with methods annotated with PostConstruct.");
                this.rootGroup.getChildren().add((Object)text);
            }
        }
        return valid;
    }

    @Bean
    public LocalStorage localStorage() {
        return new LocalStorage();
    }
}

