/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.plugin.installer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.stereotype.Service;

@Service
public class UnzipUtility {
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        int nbExtractedJars = 0;
        try {
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (entry.getName().endsWith(".jar") && ++nbExtractedJars > 1) {
                    throw new IllegalStateException("There must only be one jar file in the plugin archive.");
                }
                if (entry.isDirectory()) {
                    throw new IllegalStateException("The plugin zip archive may not contain any subdirectories.");
                }
                this.extractFile((InputStream)zipIn, filePath);
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
        }
    }

    private void extractFile(InputStream zipIn, String filePath) throws IOException {
        int read;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public List<String> getBasePackages(String jarArchive) throws IOException {
        ArrayList<String> basePackage = new ArrayList<String>();
        File destDir = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "extractedPlugin");
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(jarArchive));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDir + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile((InputStream)zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        for (File file : destDir.listFiles()) {
            if (file.getName().endsWith(".class")) {
                throw new IllegalStateException("Classes in the default package of the plugin are not allowed.");
            }
            if (!file.isDirectory()) continue;
            String basePackagePath = file.getName();
            this.collectBasePackages(basePackage, basePackagePath, file);
        }
        destDir.deleteOnExit();
        return basePackage;
    }

    private void collectBasePackages(List<String> basePackages, String curPackage, File dir) {
        if (dir.list((file, name) -> name.endsWith(".class")).length > 0) {
            basePackages.add(curPackage);
        } else {
            for (File file2 : dir.listFiles()) {
                if (!file2.isDirectory()) continue;
                String basePackagePath = curPackage + "." + file2.getName();
                this.collectBasePackages(basePackages, basePackagePath, file2);
            }
        }
    }
}

