/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class BufferedPlayer {
    private static AudioInputStream stream;
    private static AudioFormat format;
    private static SourceDataLine line;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java BufferedPlayer <clip file>");
            System.exit(0);
        }
        BufferedPlayer.createInput("Sounds/" + args[0]);
        BufferedPlayer.createOutput();
        int numBytes = (int)(stream.getFrameLength() * (long)format.getFrameSize());
        System.out.println("Size in bytes: " + numBytes);
        BufferedPlayer.checkDuration();
        BufferedPlayer.play();
        System.exit(0);
    }

    private static void checkDuration() {
        long milliseconds = (long)((float)(stream.getFrameLength() * 1000L) / stream.getFormat().getFrameRate());
        double duration = (double)milliseconds / 1000.0;
        if (duration <= 1.0) {
            System.out.println("WARNING. Duration <= 1 sec : " + duration + " secs");
            System.out.println("         The sample may not play in J2SE 1.5 -- make it longer");
        } else {
            System.out.println("Duration: " + duration + " secs");
        }
    }

    private static void createInput(String fnm) {
        try {
            stream = AudioSystem.getAudioInputStream(new File(fnm));
            format = stream.getFormat();
            System.out.println("Audio format: " + format);
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(newFormat, stream);
                System.out.println("Converted Audio format: " + newFormat);
                format = newFormat;
            }
        }
        catch (UnsupportedAudioFileException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    private static void createOutput() {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                System.out.println("Line does not support: " + format);
                System.exit(0);
            }
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    private static void play() {
        int numRead = 0;
        byte[] buffer = new byte[line.getBufferSize()];
        line.start();
        try {
            while ((numRead = stream.read(buffer, 0, buffer.length)) >= 0) {
                for (int offset = 0; offset < numRead; offset += line.write(buffer, offset, numRead - offset)) {
                }
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        line.drain();
        line.stop();
        line.close();
    }

    static {
        format = null;
        line = null;
    }
}

