/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PlayClipBF
implements LineListener {
    private static final String SOUND_DIR = "Sounds/";
    private Clip clip = null;
    private DecimalFormat df = new DecimalFormat("0.#");
    private int loopCount = 1;

    public PlayClipBF(String fnm) {
        this.loadClip(SOUND_DIR + fnm);
        this.play();
        System.out.println("Waiting");
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            System.out.println("Sleep Interrupted");
        }
    }

    private void loadClip(String fnm) {
        try {
            DataLine.Info info;
            AudioInputStream stream = AudioSystem.getAudioInputStream(this.getClass().getResource(fnm));
            AudioFormat format = stream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(newFormat, stream);
                System.out.println("Converted Audio format: " + newFormat);
                format = newFormat;
            }
            if (!AudioSystem.isLineSupported(info = new DataLine.Info(Clip.class, format))) {
                System.out.println("Unsupported Clip File: " + fnm);
                System.exit(0);
            }
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.addLineListener(this);
            this.clip.open(stream);
            stream.close();
            this.clip.setFramePosition(0);
            double duration = (double)this.clip.getMicrosecondLength() / 1000000.0;
            System.out.println("Duration: " + this.df.format(duration) + " secs");
            this.loopCount = (int)(1.0 / duration);
            System.out.println("loopCount: " + this.loopCount);
        }
        catch (UnsupportedAudioFileException audioException) {
            System.out.println("Unsupported audio file: " + fnm);
            System.exit(0);
        }
        catch (LineUnavailableException noLineException) {
            System.out.println("No audio line available for : " + fnm);
            System.exit(0);
        }
        catch (IOException ioException) {
            System.out.println("Could not read: " + fnm);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Problem with " + fnm);
            System.exit(0);
        }
    }

    private void play() {
        if (this.clip != null) {
            System.out.println("Playing...");
            this.clip.loop(this.loopCount);
        }
    }

    @Override
    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            System.out.println("Exiting...");
            this.clip.stop();
            this.clip.setFramePosition(0);
            lineEvent.getLine().close();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java PlayClipBF <clip file>");
            System.exit(0);
        }
        new PlayClipBF(args[0]);
        System.exit(0);
    }
}

