/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

public class PlayMidi
implements MetaEventListener {
    private static final int END_OF_TRACK = 47;
    private static final String SOUND_DIR = "Sounds/";
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Sequence seq = null;
    private String filename;
    private DecimalFormat df = new DecimalFormat("0.#");

    public PlayMidi(String fnm) {
        this.filename = SOUND_DIR + fnm;
        this.initSequencer();
        this.loadMidi(this.filename);
        this.play();
        System.out.println("Waiting");
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            System.out.println("Sleep Interrupted");
        }
    }

    private void initSequencer() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer == null) {
                System.out.println("Cannot get a sequencer");
                System.exit(0);
            }
            this.sequencer.open();
            this.sequencer.addMetaEventListener(this);
            if (!(this.sequencer instanceof Synthesizer)) {
                System.out.println("Linking the sequencer to a synthesizer");
                this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();
                Receiver synthReceiver = this.synthesizer.getReceiver();
                Transmitter seqTransmitter = this.sequencer.getTransmitter();
                seqTransmitter.setReceiver(synthReceiver);
            } else {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
            }
        }
        catch (MidiUnavailableException e) {
            System.out.println("No sequencer available");
            System.exit(0);
        }
    }

    private void loadMidi(String fnm) {
        try {
            this.seq = MidiSystem.getSequence(this.getClass().getResource(fnm));
            double duration = (double)this.seq.getMicrosecondLength() / 1000000.0;
            System.out.println("Duration: " + this.df.format(duration) + " secs");
        }
        catch (InvalidMidiDataException e) {
            System.out.println("Unreadable/unsupported midi file: " + fnm);
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("Could not read: " + fnm);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Problem with " + fnm);
            System.exit(0);
        }
    }

    private void play() {
        if (this.sequencer != null && this.seq != null) {
            try {
                this.sequencer.setSequence(this.seq);
                this.sequencer.start();
            }
            catch (InvalidMidiDataException e) {
                System.out.println("Corrupted/invalid midi file: " + this.filename);
                System.exit(0);
            }
        }
    }

    @Override
    public void meta(MetaMessage event) {
        if (event.getType() == 47) {
            System.out.println("Exiting...");
            this.close();
            System.exit(0);
        }
    }

    private void close() {
        if (this.sequencer != null) {
            if (this.sequencer.isRunning()) {
                this.sequencer.stop();
            }
            this.sequencer.removeMetaEventListener(this);
            this.sequencer.close();
            if (this.synthesizer != null) {
                this.synthesizer.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java PlayMidi <midi file>");
            System.exit(0);
        }
        new PlayMidi(args[0]);
        System.exit(0);
    }
}

