/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.text.DecimalFormat;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.apache.log4j.Logger;

public class PlayMidi
implements MetaEventListener {
    private static final Logger logger = Logger.getLogger(PlayMidi.class);
    private static final int END_OF_TRACK = 47;
    private static final String SOUND_DIR = "Sounds/";
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Sequence seq = null;
    private String filename;
    private DecimalFormat df = new DecimalFormat("0.#");

    public PlayMidi(String fnm) {
        this.filename = SOUND_DIR + fnm;
        this.initSequencer();
        this.loadMidi(this.filename);
        this.play();
        logger.debug((Object)"Waiting");
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            logger.debug((Object)"Sleep Interrupted");
        }
    }

    private void initSequencer() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer == null) {
                logger.fatal((Object)"Cannot get a sequencer");
                System.exit(0);
            }
            this.sequencer.open();
            this.sequencer.addMetaEventListener(this);
            if (!(this.sequencer instanceof Synthesizer)) {
                logger.debug((Object)"Linking the sequencer to a synthesizer");
                this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();
                Receiver synthReceiver = this.synthesizer.getReceiver();
                Transmitter seqTransmitter = this.sequencer.getTransmitter();
                seqTransmitter.setReceiver(synthReceiver);
            } else {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
            }
        }
        catch (MidiUnavailableException e) {
            logger.fatal((Object)"No sequencer available", (Throwable)e);
            System.exit(0);
        }
    }

    private void loadMidi(String fnm) {
        try {
            this.seq = MidiSystem.getSequence(this.getClass().getResource(fnm));
            double duration = (double)this.seq.getMicrosecondLength() / 1000000.0;
            logger.debug((Object)("Duration: " + this.df.format(duration) + " secs"));
        }
        catch (InvalidMidiDataException e) {
            logger.fatal((Object)("Unreadable/unsupported midi file: " + fnm), (Throwable)e);
            System.exit(0);
        }
        catch (IOException e) {
            logger.fatal((Object)("Could not read: " + fnm), (Throwable)e);
            System.exit(0);
        }
        catch (Exception e) {
            logger.fatal((Object)("Problem with " + fnm), (Throwable)e);
            System.exit(0);
        }
    }

    private void play() {
        if (this.sequencer != null && this.seq != null) {
            try {
                this.sequencer.setSequence(this.seq);
                this.sequencer.start();
            }
            catch (InvalidMidiDataException e) {
                logger.fatal((Object)("Corrupted/invalid midi file: " + this.filename), (Throwable)e);
                System.exit(0);
            }
        }
    }

    @Override
    public void meta(MetaMessage event) {
        if (event.getType() == 47) {
            logger.debug((Object)"Exiting...");
            this.close();
            System.exit(0);
        }
    }

    private void close() {
        if (this.sequencer != null) {
            if (this.sequencer.isRunning()) {
                this.sequencer.stop();
            }
            this.sequencer.removeMetaEventListener(this);
            this.sequencer.close();
            if (this.synthesizer != null) {
                this.synthesizer.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            logger.warn((Object)"Usage: java PlayMidi <midi file>");
            System.exit(0);
        }
        new PlayMidi(args[0]);
        System.exit(0);
    }
}

