/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SoundPlayer
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 6140818123159212676L;
    private static final Logger logger = Logger.getLogger(SoundPlayer.class);
    private static final String SOUND_DIR = "Sounds/";
    private static final String[] soundFNms = new String[]{"spacemusic.au", "tiger.aiff", "mcdonald.mid", "dog.wav"};
    private HashMap<String, AudioClip> soundsMap;
    private ArrayList<AudioClip> playingClips = new ArrayList();
    private JComboBox playListJcb;
    private JButton playButton;
    private JButton loopButton;
    private JButton stopButton;
    private JLabel statusLabel;

    public SoundPlayer() {
        super("Sound Application");
        this.initGUI();
        this.loadSounds();
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(400, 100));
        this.setResizable(false);
        this.setVisible(true);
    }

    private void initGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.playListJcb = new JComboBox<String>(soundFNms);
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(this);
        this.loopButton = new JButton("Loop");
        this.loopButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.statusLabel = new JLabel("Click Play or Loop to play the selected sound file.");
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.playListJcb);
        controlPanel.add(this.playButton);
        controlPanel.add(this.loopButton);
        controlPanel.add(this.stopButton);
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.statusLabel);
        c.add((Component)controlPanel, "Center");
        c.add((Component)statusPanel, "South");
    }

    private void loadSounds() {
        this.soundsMap = new HashMap();
        for (int i = 0; i < soundFNms.length; ++i) {
            AudioClip clip = Applet.newAudioClip(this.getClass().getResource(SOUND_DIR + soundFNms[i]));
            if (clip == null) {
                logger.warn((Object)("Problem loading Sounds/" + soundFNms[i]));
                continue;
            }
            this.soundsMap.put(soundFNms[i], clip);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.playButton) {
            this.playMusic(false);
        } else if (source == this.loopButton) {
            this.playMusic(true);
        } else if (source == this.stopButton) {
            this.stopMusic();
        }
    }

    private void playMusic(boolean toLoop) {
        String chosenFile = (String)this.playListJcb.getSelectedItem();
        AudioClip audioClip = this.soundsMap.get(chosenFile);
        if (audioClip == null) {
            this.statusLabel.setText("Sound " + chosenFile + " not loaded");
            return;
        }
        if (toLoop) {
            audioClip.loop();
        } else {
            audioClip.play();
        }
        this.playingClips.add(audioClip);
        String times = toLoop ? " repeatedly" : " once";
        this.statusLabel.setText("Playing sound " + chosenFile + times);
    }

    private void stopMusic() {
        if (this.playingClips.isEmpty()) {
            this.statusLabel.setText("Nothing to stop");
        } else {
            for (int i = 0; i < this.playingClips.size(); ++i) {
                AudioClip audioClip = this.playingClips.get(i);
                audioClip.stop();
            }
            this.playingClips.clear();
            this.statusLabel.setText("Stopped all music");
        }
    }

    public static void main(String[] args) {
        new SoundPlayer();
    }
}

