/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClassCategory(value={EClassCategory.MODEL})
public class MediaTrack
implements IPlayableTrack {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final double length;
    private MediaPlayer player;
    private BooleanProperty playing = new SimpleBooleanProperty(false);

    public MediaTrack(double length, String fileUrl) {
        this.length = length;
        Media media = new Media(fileUrl);
        Platform.runLater(() -> {
            this.player = new MediaPlayer(media);
            this.player.setOnError(() -> this.logger.error("Failed to play media " + fileUrl, (Throwable)this.player.getError()));
            this.player.setOnEndOfMedia(() -> this.stop());
        });
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void play() {
        this.player.play();
        this.playing.setValue(Boolean.valueOf(true));
        Timer timer = new Timer();
        int lengthMS = (int)(this.getLength() * 1000.0 + 1000.0);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MediaTrack.this.playing.setValue(Boolean.valueOf(false));
            }
        }, lengthMS);
    }

    @Override
    public void stop() {
        this.player.stop();
        this.playing.setValue(Boolean.valueOf(false));
    }

    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return this.playing;
    }
}

