/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.AudioClip;

@ClassCategory(value={EClassCategory.MODEL})
public class LoopTrack
implements IPlayableTrack {
    private final double length;
    private AudioClip clip;
    private BooleanProperty playing = new SimpleBooleanProperty(false);

    public LoopTrack(double length, String fileUrl) {
        this.length = length;
        Platform.runLater(() -> {
            this.clip = new AudioClip(fileUrl);
            this.clip.setCycleCount(-1);
        });
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void play() {
        this.clip.play();
        this.playing.setValue(Boolean.valueOf(true));
    }

    @Override
    public void stop() {
        this.clip.stop();
        this.playing.setValue(Boolean.valueOf(false));
    }

    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return this.playing;
    }
}

