package ch.sahits.game.openpatrician.sound;

import javafx.beans.property.ReadOnlyBooleanProperty;

/**
 * Defining the functionality of a sound track that can be played.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 17, 2015
 */
public interface IPlayableTrack {
    /**
     * Retrieve the length of the track in seconds
     * @return
     */
    double getLength();

    /**
     * Start playing the track.
     */
    void play();

    /**
     * Stop playing the track.
     */
    void stop();

    /**
     * Property indicating if the track is playing.
     * @return
     */
    ReadOnlyBooleanProperty playingProperty();
}
