/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.sound.ITrackLoader;
import ch.sahits.game.openpatrician.sound.impl.LoopTrack;
import ch.sahits.game.openpatrician.sound.impl.MediaTrack;
import ch.sahits.game.sound.data.Track;
import ch.sahits.game.sound.data.Tracks;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Unmarshaller;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TrackLoader
implements ITrackLoader {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final String SOUND_DIR = "/sound/";
    @MapType(key=String.class, value=IPlayableTrack.class)
    private HashMap<String, IPlayableTrack> soundMap = new HashMap();
    @Autowired
    @Qualifier(value="jaxb2SoundMarshaller")
    private Unmarshaller unmarshaller;
    @Autowired
    @Qualifier(value="uiTimer")
    private ScheduledExecutorService uiTimer;
    private final String fileName;

    public TrackLoader(String fileName) {
        this.fileName = fileName;
    }

    @PostConstruct
    private void loadTracks() {
        StreamSource sourceFromFile = this.getSourceFromFile(this.fileName);
        try {
            Tracks tracks = (Tracks)this.unmarshaller.unmarshal((Source)sourceFromFile);
            for (Track track : tracks.getTrack()) {
                if (track.getType().equals("l")) {
                    this.loadLoop(track);
                    continue;
                }
                if (track.getType().equals("t")) {
                    this.loadTrack(track);
                    continue;
                }
                this.logger.warn("Unknown track type " + track.getType() + " for track " + track.getSrc());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadTrack(Track track) {
        URL url = this.getClass().getResource(SOUND_DIR + track.getSrc());
        MediaTrack media = new MediaTrack(track.getLength().floatValue(), url.toExternalForm(), this.uiTimer);
        String trackId = this.getPrefix(track.getSrc());
        this.soundMap.put(trackId, media);
    }

    private void loadLoop(Track track) {
        URL url = this.getClass().getResource(SOUND_DIR + track.getSrc());
        LoopTrack loop = new LoopTrack(track.getLength().floatValue(), url.toExternalForm());
        String trackId = this.getPrefix(track.getSrc());
        this.soundMap.put(trackId, loop);
    }

    @Override
    public IPlayableTrack loadTrack(String trackID) {
        return this.soundMap.get(trackID);
    }

    private StreamSource getSourceFromFile(String fileName) {
        String imsFNm = "/" + fileName;
        this.logger.info("Reading file: " + imsFNm);
        return new StreamSource(this.getClass().getResourceAsStream(imsFNm));
    }

    private String getPrefix(String fnm) {
        int posn = fnm.lastIndexOf(".");
        if (posn == -1) {
            this.logger.debug("No prefix found for filename: " + fnm);
            return fnm;
        }
        return fnm.substring(0, posn);
    }
}

