/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TrackPlayer
implements ITrackPlayer {
    @ListType(value=IPlayableTrack.class)
    private List<IPlayableTrack> playlist = new LinkedList<IPlayableTrack>();
    private final ChangeListener<Boolean> playchangeListener = new PlayChangeListener();

    @Override
    public void add(IPlayableTrack track) {
        this.playlist.add(track);
    }

    @Override
    public void clearPlayList() {
        this.playlist.clear();
    }

    @Override
    public void play() {
        if (!this.playlist.isEmpty()) {
            IPlayableTrack track = this.playlist.get(0);
            track.play();
            track.playingProperty().addListener(this.playchangeListener);
        }
    }

    @Override
    public void stop() {
        if (!this.playlist.isEmpty()) {
            IPlayableTrack track = this.playlist.get(0);
            track.playingProperty().removeListener(this.playchangeListener);
            track.stop();
        }
    }

    private class PlayChangeListener
    implements ChangeListener<Boolean> {
        private PlayChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!newValue.booleanValue()) {
                observable.removeListener((ChangeListener)this);
                TrackPlayer.this.playlist.remove(0);
                TrackPlayer.this.play();
            }
        }
    }
}

