package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.LinkedList;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 23, 2015
 */
@Lazy
@Service
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class TrackPlayer implements ITrackPlayer {
    @ListType(IPlayableTrack.class)
    private List<IPlayableTrack> playlist = new LinkedList<>();
    private final ChangeListener<Boolean> playchangeListener = new PlayChangeListener();
    @Override
    public void add(IPlayableTrack track) {
        playlist.add(track);
    }

    @Override
    public void clearPlayList() {
        playlist.clear();
    }

    @Override
    public void play() {
       if (!playlist.isEmpty()) {
           IPlayableTrack track = playlist.get(0);
           track.play();
           track.playingProperty().addListener(playchangeListener);
       }
    }

    @Override
    public void stop() {
        if (!playlist.isEmpty()) {
            final IPlayableTrack track = playlist.get(0);
            track.playingProperty().removeListener(playchangeListener);
            track.stop();
        }
    }
    private class PlayChangeListener implements ChangeListener<Boolean> {

        @Override
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!newValue) {
                observable.removeListener(this);
                playlist.remove(0);
                play();
            }
        }
    }

}
