package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 17, 2015
 */
@ClassCategory(EClassCategory.MODEL)
public class MediaTrack implements IPlayableTrack {
    private final Logger logger = LogManager.getLogger(getClass());

    private final double length;
    private MediaPlayer player;
    private BooleanProperty playing = new SimpleBooleanProperty(false);

    private final ScheduledExecutorService timer;

    public MediaTrack(double length, String fileUrl, ScheduledExecutorService uiScheduler) {
        this.length = length;
        this.timer = uiScheduler;
        Media media = new Media(fileUrl);
        Platform.runLater(() -> {
            player = new MediaPlayer(media);
            player.setOnError(() ->
                logger.error("Failed to play media "+fileUrl, player.getError())
            );
            player.setOnEndOfMedia(() ->
                stop()
            );
        });
    }

    @Override
    public double getLength() {
        return length;
    }

    @Override
    public void play() {
       player.play();
        playing.setValue(true);
        int lengthMS = (int) (getLength() * 1000+1000);
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                playing.setValue(false);
            }
        }, lengthMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
      player.stop();
        playing.setValue(false);

    }


    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return playing;
    }
}
