package ch.sahits.game.openpatrician.sound;

/**
 * Interface for playing sound.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 23, 2015
 */
public interface ITrackPlayer {
    /**
     * Add a track to the playing queue.
     * @param track to be added
     */
    void add(IPlayableTrack track);

    /**
     * Clear all queued tracks from the list.
     */
    void clearPlayList();

    /**
     * Play the track queue. After a track is played it is removed from the queue.
     */
    void play();

    /**
     * Stop the playing.
      */
    void stop();

}
