package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.AudioClip;

/**
 * LoopTrack represents a track that can be looped.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 17, 2015
 */
@ClassCategory(EClassCategory.MODEL)
public class LoopTrack implements IPlayableTrack {
    private final double length;
    private AudioClip clip;
    private BooleanProperty playing = new SimpleBooleanProperty(false);

    public LoopTrack(double length, String fileUrl) {
        this.length = length;
        Platform.runLater(() ->{
            clip = new AudioClip(fileUrl);
            clip.setCycleCount(AudioClip.INDEFINITE);
        });
    }

    @Override
    public double getLength() {
        return length;
    }

    @Override
    public void play() {
         clip.play();
        playing.setValue(true);
    }

    @Override
    public void stop() {
         clip.stop();
        playing.setValue(false);
    }



    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return playing;
    }
}
