/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.MODEL})
public class MediaTrack
implements IPlayableTrack {
    private static final Logger log = LoggerFactory.getLogger(MediaTrack.class);
    private final double length;
    private MediaPlayer player;
    private BooleanProperty playing = new SimpleBooleanProperty(false);
    private final ScheduledExecutorService timer;

    public MediaTrack(double length, String fileUrl, ScheduledExecutorService uiScheduler) {
        this.length = length;
        this.timer = uiScheduler;
        Media media = new Media(fileUrl);
        Platform.runLater(() -> {
            this.player = new MediaPlayer(media);
            this.player.setOnError(() -> log.error("Failed to play media " + fileUrl, (Throwable)this.player.getError()));
            this.player.setOnEndOfMedia(this::stop);
        });
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void play() {
        this.player.play();
        this.playing.setValue(Boolean.valueOf(true));
        int lengthMS = (int)(this.getLength() * 1000.0 + 1000.0);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MediaTrack.this.playing.setValue(Boolean.valueOf(false));
            }
        }, (long)lengthMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.player.stop();
        this.playing.setValue(Boolean.valueOf(false));
    }

    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return this.playing;
    }
}

