package ch.sahits.game.openpatrician.sound.impl;

import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import lombok.extern.slf4j.Slf4j;

import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 17, 2015
 */
@Slf4j
@ClassCategory(EClassCategory.MODEL)
public class MediaTrack implements IPlayableTrack {

    private final double length;
    private MediaPlayer player;
    private BooleanProperty playing = new SimpleBooleanProperty(false);

    private final ScheduledExecutorService timer;

    public MediaTrack(double length, String fileUrl, ScheduledExecutorService uiScheduler) {
        this.length = length;
        this.timer = uiScheduler;
        Media media = new Media(fileUrl);
        Platform.runLater(() -> {
            player = new MediaPlayer(media);
            player.setOnError(() ->
                log.error("Failed to play media "+fileUrl, player.getError())
            );
            player.setOnEndOfMedia(this::stop
            );
        });
    }

    @Override
    public double getLength() {
        return length;
    }

    @Override
    public void play() {
       player.play();
        playing.setValue(true);
        int lengthMS = (int) (getLength() * 1000+1000);
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                playing.setValue(false);
            }
        }, lengthMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
      player.stop();
        playing.setValue(false);

    }


    @Override
    public ReadOnlyBooleanProperty playingProperty() {
        return playing;
    }
}
