package ch.sahits.game.openpatrician.sound;

import ch.sahits.game.openpatrician.sound.impl.TrackLoader;
import ch.sahits.game.openpatrician.sound.impl.TrackPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 17, 2015
 */
@Configuration
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class SoundConfiguration {
    @Bean
    @Lazy
    public ITrackLoader trackLoader() {
       return new TrackLoader("soundTrack.xml");
    }
    @Bean
    public Jaxb2Marshaller jaxb2SoundMarshaller() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.sound.data");
        return bean;
    }
    @Bean
    public ITrackPlayer soundPlayer() {
        return new TrackPlayer();
    }
}
