/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.standalone;

import ch.sahits.game.openpatrician.utilities.LocalStorage;
import ch.sahits.game.openpatrician.utilities.plugin.BasePluginDefinition;
import ch.sahits.game.openpatrician.utilities.plugin.PluginConfiguration;
import ch.sahits.game.openpatrician.utilities.service.UnzipUtility;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StartupService {
    private static final Logger log = LoggerFactory.getLogger(StartupService.class);

    public boolean checkVersion() {
        String jreVersion = (String)System.getProperties().get("java.version");
        if (!jreVersion.startsWith("9.0")) {
            log.error("JRE must be of version 9");
            System.out.println("JRE must be of version 9");
            return false;
        }
        return true;
    }

    public void logEnvironment() {
        Properties sysprops = System.getProperties();
        LoggerContext logContext = (LoggerContext)LogManager.getContext();
        if (log.isInfoEnabled()) {
            log.info("Logging into file: " + ((RollingFileAppender)logContext.getConfiguration().getAppender("FileAppender")).getFileName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Java VM version").append(": ").append(sysprops.get("java.vm.version"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java runtime version").append(": ").append(sysprops.get("java.runtime.version"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java VM vendor").append(": ").append(sysprops.get("java.vm.vendor"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java VM name").append(": ").append(sysprops.get("java.vm.name"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java version").append(": ").append(sysprops.get("java.version"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Java specification version").append(": ").append(sysprops.get("java.specification.version"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Graphics environment").append(": ").append(sysprops.get("java.awt.graphicsenv"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("User country").append(": ").append(sysprops.get("user.country"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("User language").append(": ").append(sysprops.get("user.language"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS architecture").append(": ").append(sysprops.get("os.arch"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS name").append(": ").append(sysprops.get("os.name"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("OS version").append(": ").append(sysprops.get("os.version"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Classpath").append(": ").append(sysprops.get("java.class.path"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("Start command").append(": ").append(sysprops.get("sun.java.command"));
        if (log.isInfoEnabled()) {
            log.info(sb.toString());
        }
    }

    public void unpackPlugins() {
        LocalStorage localeStorage = new LocalStorage();
        File pluginDir = localeStorage.getPluginDirectory();
        String[] zipFiles = pluginDir.list((dir, name) -> name.endsWith(".zip"));
        UnzipUtility unzipper = new UnzipUtility();
        for (String zipFile : zipFiles) {
            String zipFileName = localeStorage.getPluginDirectoryPath() + File.separatorChar + zipFile;
            try {
                String pluginFilePath = unzipper.unzipPluginDescriptor(zipFileName);
                File pluginDesc = new File(pluginFilePath);
                PluginConfiguration pluginConfiguration = new PluginConfiguration();
                Unmarshaller um = pluginConfiguration.jaxbPluginUnMarshaller();
                BasePluginDefinition plugin = (BasePluginDefinition)um.unmarshal(pluginDesc);
                String outputdirectory = localeStorage.getPluginTypeDirecotryPath(plugin.getType(), zipFile);
                if (this.isPluginUnziped(outputdirectory)) {
                    System.out.println("Should delete old plugin");
                    File dir2 = new File(outputdirectory);
                    FileUtils.deleteDirectory((File)dir2);
                }
                unzipper.unzip(zipFileName, outputdirectory);
                File f = new File(zipFileName);
                f.delete();
            }
            catch (IOException e) {
                log.warn("Failed to extract plugin " + zipFile, (Throwable)e);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isPluginUnziped(String pluginPath) {
        File f = new File(pluginPath);
        return f.exists();
    }
}

