/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.standalone;

import ch.sahits.game.openpatrician.display.CheatKeyEventListener;
import ch.sahits.game.openpatrician.display.CommandLineArguments;
import ch.sahits.game.openpatrician.display.IOpenPatricianApplicationWindow;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.display.StandaloneConfiguration;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.scene.StartupScene;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.event.EGameStatusChange;
import ch.sahits.game.openpatrician.event.GameStateChange;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.javafx.event.AggregateEventHandler;
import ch.sahits.game.openpatrician.javafx.event.CloseApplicationEventHandler;
import ch.sahits.game.openpatrician.javafx.event.MouseClickLocationEventHandler;
import ch.sahits.game.openpatrician.standalone.StartupService;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.service.GamePropertyUtility;
import ch.sahits.game.openpatrician.utilities.spring.DependentAnnotationConfigApplicationContext;
import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.net.URL;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@Import(value={StandaloneConfiguration.class})
@ClassCategory(value={EClassCategory.STARTUP})
public class OpenPatricianApplication
extends Application
implements IOpenPatricianApplicationWindow {
    private static final Logger log = LoggerFactory.getLogger(OpenPatricianApplication.class);
    private StartupService startupService;
    private GamePropertyUtility gamePropertyUtility;
    private int width = 1074;
    private int height = 766;
    private boolean fullscreen = false;
    private Stage primaryStage;
    private final AggregateEventHandler<KeyEvent> keyEventHandlerAggregate = new AggregateEventHandler();
    private final MouseClickLocationEventHandler mouseClickEventHandler;
    private ApplicationContext context;

    public OpenPatricianApplication() {
        CloseApplicationEventHandler closeEventHandler = new CloseApplicationEventHandler();
        this.mouseClickEventHandler = new MouseClickLocationEventHandler();
        EventHandler fullScreenEventHandler = event -> {
            try {
                if (event.getCode().equals((Object)KeyCode.F) && event.isControlDown()) {
                    this.updateFullscreenMode();
                }
            }
            catch (RuntimeException e) {
                log.error("Failed to switch to/from fullscreen mode", (Throwable)e);
            }
        };
        EventHandler closeEventWindowKeyHandler = event -> {
            if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                log.info("Pressed ESC");
                ((MainGameView)this.context.getBean(MainGameView.class)).closeEventView();
            }
        };
        this.addKeyEventHandler((EventHandler)closeEventHandler);
        this.addKeyEventHandler(fullScreenEventHandler);
        this.addKeyEventHandler(closeEventWindowKeyHandler);
    }

    private void addKeyEventHandler(EventHandler<KeyEvent> eventHandler) {
        this.keyEventHandlerAggregate.addEventHandler(eventHandler);
    }

    public static void main(String[] args) {
        OpenPatricianApplication.launch((String[])args);
    }

    public void init() {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{OpenPatricianApplication.class});
        this.context = builder.contextClass(DependentAnnotationConfigApplicationContext.class).run(this.getParameters().getRaw().toArray(new String[0]));
        this.startupService = (StartupService)this.context.getBean(StartupService.class);
        this.gamePropertyUtility = (GamePropertyUtility)this.context.getBean(GamePropertyUtility.class);
        if (this.startupService.checkVersion()) {
            this.startupService.logEnvironment();
            CommandLineArguments cmdHelper = new CommandLineArguments();
            Options opts = cmdHelper.createCommandLineOptions();
            CommandLine cmdLine = cmdHelper.parseCommandLine(opts, this.getParameters().getRaw().toArray(new String[this.getParameters().getRaw().size()]));
            if (cmdLine.hasOption("h")) {
                cmdHelper.printHelp(opts);
                System.exit(0);
            }
            if (cmdLine.hasOption("version")) {
                System.out.println("OpenPatrician version: " + OpenPatricianApplication.class.getPackage().getImplementationVersion());
                System.exit(0);
            }
            cmdHelper.persistAsPropertyFile(cmdLine);
        }
    }

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.primaryStage.setMinWidth(1074.0);
        this.primaryStage.setMinHeight(766.0);
        primaryStage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/icons/trade-icon.png")));
        UIFactory uiFactory = (UIFactory)this.context.getBean(UIFactory.class);
        uiFactory.setApplicationWindow((IOpenPatricianApplicationWindow)this);
        StartupScene startupS = uiFactory.getStartupScene();
        Scene defaultScene = new Scene((Parent)startupS.getRoot(), (double)this.width, (double)this.height);
        defaultScene.getStylesheets().add((Object)"/styles/font.css");
        this.fullscreen = Boolean.valueOf((String)this.gamePropertyUtility.getProperties().get("window.fullscreen"));
        startupS.setSceneChangeable((SceneChangeable)this);
        defaultScene.setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        defaultScene.setOnKeyPressed((EventHandler)this.keyEventHandlerAggregate);
        try {
            CheatKeyEventListener cheatListener = (CheatKeyEventListener)this.context.getBean(CheatKeyEventListener.class);
            if (cheatListener != null) {
                this.addKeyEventHandler((EventHandler)cheatListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(defaultScene);
        primaryStage.setFullScreen(this.fullscreen);
        primaryStage.setFullScreenExitHint("");
        primaryStage.setTitle("OpenPatrician");
        primaryStage.setScene(defaultScene);
        primaryStage.show();
    }

    private void setCursor(Scene scene) {
        URL url = this.getClass().getResource("/icons/64/cursor.png");
        try {
            Image img = new Image(url.openStream());
            scene.setCursor((Cursor)new ImageCursor(img));
        }
        catch (IOException e) {
            log.warn("Failed to load cursor icon from {}", (Object)url);
        }
    }

    public void changeScene(OpenPatricianScene scene) {
        this.primaryStage.getScene().setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        this.primaryStage.getScene().setOnKeyPressed((EventHandler)this.keyEventHandlerAggregate);
        this.primaryStage.getScene().setRoot((Parent)scene.getRoot());
    }

    public void updateFullscreenMode() {
        this.fullscreen = !this.fullscreen;
        this.primaryStage.setFullScreen(this.fullscreen);
    }

    public double getSceneWidth() {
        return this.primaryStage.getScene().getWidth();
    }

    public double getSceneHeight() {
        return this.primaryStage.getScene().getHeight();
    }

    public void stop() throws Exception {
        System.out.println("Stopping the UI Application");
        this.stopUIApplicationContext();
        super.stop();
    }

    private void stopUIApplicationContext() {
        AsyncEventBus eventBus = (AsyncEventBus)this.context.getBean("serverClientEventBus");
        eventBus.post((Object)new GameStateChange(EGameStatusChange.SHUTDOWN));
        ((AbstractApplicationContext)this.context).close();
    }
}

