/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.testutilities;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.SwingUtilities;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JavaFXThreadingRule
implements TestRule {
    private static boolean jfxIsSetup;

    public Statement apply(Statement statement, Description description) {
        return new OnJFXThreadStatement(statement);
    }

    private static class OnJFXThreadStatement
    extends Statement {
        private final Statement statement;
        private Throwable rethrownException = null;

        public OnJFXThreadStatement(Statement aStatement) {
            this.statement = aStatement;
        }

        public void evaluate() throws Throwable {
            if (!jfxIsSetup) {
                this.setupJavaFX();
                jfxIsSetup = true;
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        statement.evaluate();
                    }
                    catch (Throwable e) {
                        rethrownException = e;
                    }
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
            if (this.rethrownException != null) {
                throw this.rethrownException;
            }
        }

        protected void setupJavaFX() throws InterruptedException {
            long timeMillis = System.currentTimeMillis();
            final CountDownLatch latch = new CountDownLatch(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new JFXPanel();
                    latch.countDown();
                }
            });
            System.out.println("javafx initialising...");
            latch.await();
            System.out.println("javafx is initialised in " + (System.currentTimeMillis() - timeMillis) + "ms");
        }
    }
}

