package ch.sahits.game.openpatrician.testutilities;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Test utility helper to start the Platform/Toolkit without starting an Application.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Feb 22, 2015
 */
public class FakeApplicationStartup {
    public static void startupFakeApplication() {
        final Runnable dummyRunnable = new Runnable() {
            @Override
            public void run() {
                System.out.println("Startup platform");
            }
        };
        try {
            Class<?> platformClass = FakeApplicationStartup.class.getClassLoader().loadClass("com.sun.javafx.application.PlatformImpl");
            Method startup = platformClass.getMethod("startup", new Class[]{Runnable.class});
            startup.invoke(null, new Object[]{dummyRunnable});
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        // This code belongs to Oracles internal API and will not work with any other JVM

//        PlatformImpl.startup(dummyRunnable);
    }
}
