/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.testutilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.springframework.util.ReflectionUtils;

public class OpenPatricianReflectionUtils {
    protected void setField(String fieldName, Object valueToSet, Object instance) {
        Field field = ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)instance, (Object)valueToSet);
        field.setAccessible(false);
    }

    protected void invokeMethod(String methodName, Object instance) {
        Method method = ReflectionUtils.findMethod(instance.getClass(), (String)methodName);
        method.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)method, (Object)instance);
        method.setAccessible(false);
    }

    protected Properties getSnikkaProperties() {
        Properties configuration = new Properties();
        configuration.setProperty("initialValue", "20000");
        configuration.setProperty("minNumberOfSailors", "5");
        configuration.setProperty("maxSailors", "12");
        configuration.setProperty("size", "4711");
        configuration.setProperty("reductionLevel1", "30");
        configuration.setProperty("reductionLevel2", "50");
        configuration.setProperty("speedkmperh", "10");
        configuration.setProperty("distanceInKmForOneHealthPointReduction", "350");
        return configuration;
    }

    protected Object getField(String fieldName, Object instance) {
        Field field = ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        field.setAccessible(true);
        Object obj = ReflectionUtils.getField((Field)field, (Object)instance);
        field.setAccessible(false);
        return obj;
    }
}

