package ch.sahits.game.openpatrician.testutilities;

import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

/**
 * Utility used in tests.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 09, 2014
 */
public class OpenPatricianReflectionUtils {
    protected void setField(String fieldName, Object valueToSet, Object instance) {
        Field field = ReflectionUtils.findField(instance.getClass(), fieldName);
        field.setAccessible(true);
        ReflectionUtils.setField(field, instance, valueToSet);
        field.setAccessible(false);
    }

    protected void invokeMethod(String methodName, Object instance) {
        Method method = ReflectionUtils.findMethod(instance.getClass(), methodName);
        method.setAccessible(true);
        ReflectionUtils.invokeMethod(method, instance);
        method.setAccessible(false);
    }

    protected Properties getSnikkaProperties() {
        Properties configuration = new Properties();
        configuration.setProperty("initialValue", "20000");
        configuration.setProperty("minNumberOfSailors", "5");
        configuration.setProperty("maxSailors", "12");
        configuration.setProperty("size", "4711");
        configuration.setProperty("reductionLevel1", "30");
        configuration.setProperty("reductionLevel2", "50");
        configuration.setProperty("speedkmperh", "10");
        configuration.setProperty("distanceInKmForOneHealthPointReduction", "350");
        return configuration;
    }

    protected Object getField(String fieldName, Object instance) {
        Field field = ReflectionUtils.findField(instance.getClass(), fieldName);
        field.setAccessible(true);
        Object obj = ReflectionUtils.getField(field, instance);
        field.setAccessible(false);
        return obj;
    }
}
