/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class Environment {
    Map<String, String> environment = new TreeMap<String, String>();

    public Environment(Map<String, String> environmentMap) {
        for (String key : environmentMap.keySet()) {
            this.environment.put(key.toLowerCase(), environmentMap.get(key));
        }
    }

    public Environment() {
        this(System.getenv());
    }

    public void addToPath(String dir) {
        String path = this.environment.get("path");
        path = path == null ? dir : path + System.getProperty("path.separator") + dir;
        this.environment.put("path", path);
    }

    public void addToPath(File dir) {
        this.addToPath(dir.getAbsolutePath());
    }

    public String[] getEnvp() {
        LinkedList<String> env = new LinkedList<String>();
        for (String key : this.environment.keySet()) {
            env.add(key + "=" + this.environment.get(key));
        }
        String[] envp = new String[env.size()];
        return env.toArray(envp);
    }

    public Map<String, String> getEnvironmentMap() {
        return this.environment;
    }

    public String getValue(String key) {
        return this.environment.get(key.toLowerCase());
    }
}

