/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import ch.sf.htt.Environment;
import ch.sf.htt.ExecResult;
import ch.sf.htt.Httest;
import ch.sf.htt.HttestFailedException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class HttestWrapper {
    private Httest httest;
    protected String file;

    public HttestWrapper(String file) {
        this.file = file;
    }

    public Httest getHttest() {
        return this.httest;
    }

    public void setUp() throws Exception {
    }

    public void setUp(Properties props) throws Exception {
        this.httest = Httest.instance(props);
    }

    public ExecResult runScript(String scriptFileName) throws IOException, HttestFailedException {
        return this.httest.runScript(scriptFileName, new String[0]);
    }

    public void setEnvironment(Environment environment) {
        this.httest.setEnvironment(environment);
    }

    public void setVerbose(boolean verbose) {
        this.httest.setVerbose(verbose);
    }

    public static Collection<Object[]> collectHttestScript(Properties props) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HttestWrapper.addHttestScripts(new File(props.getProperty("basedir") + "/" + props.getProperty("scriptdir")), data);
        return data;
    }

    private static void addHttestScripts(File file, Collection<Object[]> all) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isFile()) {
                    String script = file.getName() + "/" + child.getName();
                    Object[] data = new Object[]{script};
                    all.add(data);
                }
                HttestWrapper.addHttestScripts(child, all);
            }
        }
    }
}

