/*
 * Decompiled with CFR 0.152.
 */
package ch.sf.htt;

import ch.sf.htt.Environment;
import ch.sf.htt.ExecResult;
import ch.sf.htt.HttestError;
import ch.sf.htt.HttestFailedException;
import ch.sf.htt.ITestListener;
import ch.sf.htt.OperatingSystem;
import ch.sf.htt.ProcessStreamHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Httest {
    public static final String VERSION_PROPERTY = "httest.version";
    public static final String HTTEST_HOME = "HTTEST_HOME";
    public static final String HTTEST_WORKDIR = "HTTEST_WORKDIR";
    public static final String HTTEST_ENV = "HTTEST_ENV";
    public static final String ENV_ACTION_INHERIT = "inherit";
    public static final String ENV_ACTION_REPLACE = "replace";
    public static final String ENV_ACTION_MERGE = "merge";
    private File binariesDir;
    private File workingDir;
    private Environment environment;
    private boolean verbose = false;
    private boolean interrupted = false;
    private ProcessStreamHandler outHandler = null;
    private ProcessStreamHandler errHandler = null;
    private Process proc = null;
    private List<HttestError> httestErrors = new ArrayList<HttestError>();
    private static final OperatingSystem OS = OperatingSystem.get();

    public static Httest instance(File binariesDir, File workingDir, Environment environment) {
        return new Httest(binariesDir, workingDir, environment);
    }

    public static Httest instance(Properties props) {
        Environment environment;
        String httestHome = props.getProperty(HTTEST_HOME);
        if (httestHome == null) {
            throw new IllegalArgumentException("HTTEST_HOME is not defined!");
        }
        File binariesDir = new File(httestHome);
        String httestWorkdir = props.getProperty(HTTEST_WORKDIR);
        File workingDir = httestWorkdir == null ? new File(".") : new File(httestWorkdir);
        String httestEnv = props.getProperty(HTTEST_ENV);
        if (httestEnv == null) {
            httestEnv = ENV_ACTION_INHERIT;
        }
        Properties propMap = props;
        Map<String, String> sysEnvMap = System.getenv();
        if (httestEnv.equalsIgnoreCase(ENV_ACTION_REPLACE)) {
            environment = new Environment(propMap);
        } else if (httestEnv.equalsIgnoreCase(ENV_ACTION_MERGE)) {
            HashMap<String, String> mergedMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : sysEnvMap.entrySet()) {
                mergedMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : propMap.entrySet()) {
                mergedMap.put(entry.getKey(), entry.getValue());
            }
            environment = new Environment(mergedMap);
        } else {
            environment = new Environment();
        }
        return new Httest(binariesDir, workingDir, environment);
    }

    private Httest(File binariesDir, File workingDir, Environment environment) {
        this.binariesDir = binariesDir;
        if (binariesDir == null) {
            throw new IllegalArgumentException("binariesDir is null!");
        }
        this.workingDir = workingDir == null ? new File(".") : workingDir;
        this.environment = environment == null ? new Environment() : environment;
    }

    public ExecResult runScript(File scriptFile, String ... commandLineArgs) throws IOException, HttestFailedException {
        return this.runScript(null, scriptFile, commandLineArgs);
    }

    public ExecResult runScript(String scriptFileName, String ... commandLineArgs) throws IOException, HttestFailedException {
        return this.runScript(null, new File(scriptFileName), commandLineArgs);
    }

    public ExecResult runScript(ITestListener console, File scriptFile, String ... commandLineArgs) throws IOException, HttestFailedException {
        if (!scriptFile.exists()) {
            throw new FileNotFoundException("Missing script file: " + scriptFile.getAbsolutePath());
        }
        ExecResult execResult = this.executeBinary(scriptFile, console, commandLineArgs);
        if (!this.interrupted) {
            if (execResult.getReturnCode() != 0 || console != null) {
                List<String> errs = execResult.getStandardErr();
                if (execResult.getReturnCode() != 0) {
                    throw new HttestFailedException("httest failed. RC: " + execResult.getReturnCode() + ", stderr: " + errs.get(errs.size() - 1), execResult);
                }
            }
        } else {
            throw new HttestFailedException("httest was interrupted", execResult);
        }
        return execResult;
    }

    public ExecResult runScript(ITestListener console, String scriptFileName, String ... commandLineArgs) throws IOException, HttestFailedException {
        return this.runScript(console, new File(scriptFileName), commandLineArgs);
    }

    public String testBinary() throws IOException {
        ExecResult result = null;
        File httestFile = this.getHttestBinaryExecutableFile();
        String[] args = new String[]{httestFile.getCanonicalPath(), "-V"};
        result = this.doExecute(null, args);
        String firstLine = result.getStandardOut().get(0);
        if (firstLine.trim().indexOf(" ") != -1) {
            String version = firstLine.substring(firstLine.indexOf(" ") + 1);
            System.setProperty(VERSION_PROPERTY, version);
            return version;
        }
        if (result != null) {
            for (String line : result.getStandardOut()) {
                System.out.println("stdout> " + line);
            }
            for (String line : result.getStandardErr()) {
                System.out.println("stderr> " + line);
            }
        }
        throw new IllegalStateException("Failed to detect 'httest' executable version!");
    }

    private ExecResult executeBinary(File scriptFile, ITestListener listener, String ... commandLineArgs) throws IOException {
        File httestFile = this.getHttestBinaryExecutableFile();
        String[] args = new String[2];
        if (commandLineArgs != null && commandLineArgs.length > 0) {
            args = new String[2 + commandLineArgs.length];
            int argNo = 1;
            for (int pos = 0; pos < commandLineArgs.length; ++pos) {
                args[argNo] = commandLineArgs[pos];
                if (commandLineArgs[pos] == null) {
                    throw new IllegalStateException("INVALID ARGUMENT: " + pos);
                }
                ++argNo;
            }
        }
        args[0] = httestFile.getCanonicalPath();
        args[args.length - 1] = scriptFile.getCanonicalPath();
        ExecResult result = this.doExecute(listener, args);
        return result;
    }

    private ExecResult doExecute(ITestListener listener, String[] args) {
        this.interrupted = false;
        for (int pos = 0; pos < args.length; ++pos) {
            String arg = args[pos];
            if (arg == null) {
                throw new IllegalStateException("NULL ARGUMENT: " + pos);
            }
            System.out.println(">> htt argument: " + arg);
        }
        String[] envp = this.environment.getEnvp();
        ExecResult result = null;
        try {
            List<String> stdErr;
            if (listener != null) {
                listener.setState(ITestListener.STATE.RUNNING);
            }
            this.proc = Runtime.getRuntime().exec(args, envp, this.workingDir);
            this.outHandler = new ProcessStreamHandler(this.proc.getInputStream(), "stdout", listener);
            this.outHandler.setVerbose(this.isVerbose());
            this.errHandler = new ProcessStreamHandler(this.proc.getErrorStream(), "stderr", listener);
            this.errHandler.setVerbose(this.isVerbose());
            this.outHandler.start();
            this.errHandler.start();
            int ret = this.proc.waitFor();
            this.outHandler.join();
            this.errHandler.join();
            if (!this.outHandler.hasCompleted()) {
                listener.setState(ITestListener.STATE.INVALID);
                throw new IllegalStateException("stdout-handler not completed!");
            }
            if (!this.errHandler.hasCompleted()) {
                listener.setState(ITestListener.STATE.INVALID);
                throw new IllegalStateException("stderr-handler not completed!");
            }
            result = new ExecResult(ret, this.outHandler.getText(), this.errHandler.getText());
            if (listener != null) {
                if (result.wasSuccessful()) {
                    listener.setState(ITestListener.STATE.SUCCESS);
                } else if (this.interrupted) {
                    listener.setState(ITestListener.STATE.STOPPED);
                } else {
                    listener.setState(ITestListener.STATE.FAILED);
                }
            }
            if ((stdErr = result.getStandardErr()) != null && stdErr.size() > 0) {
                for (String line : stdErr) {
                    if (line.trim().length() <= 0 || line.indexOf(":") <= 0) continue;
                    this.httestErrors.add(this.processErrorMessage(line));
                }
            }
        }
        catch (Exception e) {
            System.out.println("--------------> Execution of " + args[0] + " failed.");
            e.printStackTrace();
        }
        return result;
    }

    private HttestError processErrorMessage(String line) {
        try {
            if (line.indexOf(":") > 0) {
                String fileName = line.substring(0, line.indexOf(":"));
                String msg = line.substring(line.indexOf(":") + 1);
                String lineNoTxt = msg.substring(0, msg.indexOf(":"));
                String errMsg = msg.substring(msg.indexOf("error:") + 7);
                System.out.println("--> filename: " + fileName);
                System.out.println("--> line number: " + lineNoTxt);
                System.out.println("--> message: " + errMsg);
                return new HttestError(new File(fileName), Integer.parseInt(lineNoTxt), errMsg);
            }
        }
        catch (Exception ex) {
            System.err.println("Invalid error message, unable to process: " + line);
        }
        return null;
    }

    public List<HttestError> getErrors() {
        return this.httestErrors;
    }

    public void interruptExecution() {
        if (this.proc != null) {
            this.interrupted = true;
            this.outHandler.interrupt();
            this.errHandler.interrupt();
            this.proc.destroy();
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public File getHttestBinaryExecutableFile() {
        return new File(this.binariesDir, Httest.getHttestBinaryExecutableFilename());
    }

    public static String getHttestBinaryExecutableFilename() {
        if (OS == OperatingSystem.WINDOWS) {
            return "httest.exe";
        }
        return "httest";
    }

    public File getHtntlmFile() {
        return new File(this.binariesDir, Httest.getHtntlmFilename());
    }

    public static String getHtntlmFilename() {
        if (OS == OperatingSystem.WINDOWS) {
            return "htntlm.exe";
        }
        return "htntlm";
    }

    public File getBinariesDir() {
        return this.binariesDir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static OperatingSystem getOs() {
        return OS;
    }
}

